/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.system;

import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;

public final class Config {
    public static final int RMI_DEFAULT_PORT = 4840;
    private File workDir = null;
    private File configDir = null;
    private Locale locale = null;
    private Settings settings = null;
    private File systemPluginDir = null;
    private File userPluginDir = null;
    private File updateDir = null;
    private File[] pluginDirs = null;

    protected Config() throws Exception {
    }

    protected synchronized void init() throws Exception {
        if (this.workDir == null) {
            try {
                this.workDir = Application.getPlatform().getWorkdir();
            }
            catch (Exception e) {
                this.workDir = new File(Application.getPlatform().getDefaultWorkdir());
                Logger.error((String)("unable to determine workdir, fallback to default workdir " + this.workDir), (Throwable)e);
                throw e;
            }
            File deploy = new File(this.workDir, "deploy");
            if (deploy.exists() && deploy.isDirectory() && deploy.canWrite()) {
                Logger.info((String)("migration: removing deprecated deploy dir: " + deploy));
                deploy.delete();
            }
        }
        if (this.settings == null) {
            this.settings = new Settings(this.getClass());
            this.settings.setStoreWhenRead(true);
        }
    }

    public int getRmiPort() {
        return this.settings.getInt("jameica.system.rmi.serverport", 4840);
    }

    public void setRmiPort(int port) throws ApplicationException {
        if (port < 1 || port > 65535) {
            throw new ApplicationException(Application.getI18n().tr("TCP-Portnummer f\u00fcr Netzwerkbetrieb au\u00dferhalb des g\u00fcltigen Bereichs von {0} bis {1}", new String[]{"1", "65535"}));
        }
        ServerSocket s = null;
        try {
            Logger.info((String)("testing TCP port " + port));
            s = new ServerSocket(port);
        }
        catch (BindException e) {
            throw new ApplicationException(Application.getI18n().tr("Die angegebene TCP-Portnummer {0} ist bereits belegt", "" + port));
        }
        catch (IOException ioe) {
            Logger.error((String)("error while opening socket on port " + port));
            throw new ApplicationException(Application.getI18n().tr("Fehler beim Testen der TCP-Portnummer {0}. Ist der Port bereits belegt?", "" + port));
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception exception) {}
            }
        }
        this.settings.setAttribute("jameica.system.rmi.serverport", port);
    }

    public boolean getRmiSSL() {
        return this.settings.getBoolean("jameica.system.rmi.enablessl", true);
    }

    public boolean getRmiUseClientAuth() {
        return this.settings.getBoolean("jameica.system.rmi.clientauth", true);
    }

    public String getProxyHost() {
        return this.settings.getString("jameica.system.proxy.host", null);
    }

    public int getProxyPort() {
        return this.settings.getInt("jameica.system.proxy.port", -1);
    }

    public void setProxyHost(String host) {
        if ("".equals(host)) {
            host = null;
        }
        this.settings.setAttribute("jameica.system.proxy.host", host);
    }

    public void setProxyPort(int port) throws ApplicationException {
        if (port == -1) {
            this.settings.setAttribute("jameica.system.proxy.port", -1);
            return;
        }
        if (port < 1 || port > 65535) {
            throw new ApplicationException(Application.getI18n().tr("TCP-Portnummer f\u00fcr Proxy au\u00dferhalb des g\u00fcltigen Bereichs von {0} bis {1}", new String[]{"1", "65535"}));
        }
        this.settings.setAttribute("jameica.system.proxy.port", port);
    }

    public String getHttpsProxyHost() {
        return this.settings.getString("jameica.system.proxy.https.host", null);
    }

    public int getHttpsProxyPort() {
        return this.settings.getInt("jameica.system.proxy.https.port", -1);
    }

    public void setHttpsProxyHost(String host) {
        if ("".equals(host)) {
            host = null;
        }
        this.settings.setAttribute("jameica.system.proxy.https.host", host);
    }

    public void setHttpsProxyPort(int port) throws ApplicationException {
        if (port == -1) {
            this.settings.setAttribute("jameica.system.proxy.https.port", -1);
            return;
        }
        if (port < 1 || port > 65535) {
            throw new ApplicationException(Application.getI18n().tr("TCP-Portnummer f\u00fcr HTTPS-Proxy au\u00dferhalb des g\u00fcltigen Bereichs von {0} bis {1}", new String[]{"1", "65535"}));
        }
        this.settings.setAttribute("jameica.system.proxy.https.port", port);
    }

    public boolean getUseSystemProxy() {
        return this.settings.getBoolean("jameica.system.proxy.usesystem", false);
    }

    public void setUseSystemProxy(boolean b) {
        this.settings.setAttribute("jameica.system.proxy.usesystem", b);
    }

    public boolean getTrustJavaCerts() {
        return this.settings.getBoolean("jameica.system.ssl.trustjava", true);
    }

    public void setTrustJavaCerts(boolean b) {
        this.settings.setAttribute("jameica.system.ssl.trustjava", b);
    }

    public boolean getShareServices() {
        return this.settings.getBoolean("jameica.system.rmi.shareservices", true);
    }

    public boolean getMulticastLookup() {
        return this.settings.getBoolean("jameica.system.multicastlookup", true);
    }

    public void setRmiSSL(boolean b) {
        this.settings.setAttribute("jameica.system.rmi.enablessl", b);
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        try {
            Locale l = Config.findLocale(this.settings.getString("jameica.system.locale", null));
            if (l == null) {
                l = Locale.getDefault();
            }
            try {
                Logger.info((String)"checking resource bundle for language");
                ResourceBundle.getBundle("lang/system_messages", l);
            }
            catch (Exception e) {
                Logger.warn((String)("no resource bundle found for locale " + l));
                l = Locale.GERMANY;
                Logger.warn((String)("fallback to system locale " + l));
            }
            this.locale = l;
            Logger.info((String)("active language: " + this.locale));
            Locale.setDefault(this.locale);
            return this.locale;
        }
        catch (Throwable t) {
            Logger.info((String)"not found. fallback to system default");
            return Locale.getDefault();
        }
    }

    private static Locale findLocale(String s) {
        if ((s = StringUtils.trimToNull((String)s)) == null) {
            return null;
        }
        Logger.info((String)("configured language: " + s));
        int minus = s.indexOf("_");
        if (minus != -1) {
            String country = s.substring(minus + 1);
            s = s.substring(0, minus);
            if (country != null && country.length() > 0) {
                Logger.info((String)("configured country: " + country));
                return new Locale(s, country);
            }
        }
        return new Locale(s);
    }

    public void setLocale(Locale l) {
        if (l == null) {
            return;
        }
        this.locale = l;
        String lang = this.locale.getLanguage();
        String country = this.locale.getCountry();
        if (country != null && country.length() > 0) {
            this.settings.setAttribute("jameica.system.locale", lang + "_" + country);
        } else {
            this.settings.setAttribute("jameica.system.locale", lang);
        }
    }

    public File[] getPluginDirs() {
        if (this.pluginDirs != null) {
            return this.pluginDirs;
        }
        File sysPluginDir = this.getSystemPluginDir();
        File usrPluginDir = this.getUserPluginDir();
        boolean found = false;
        ArrayList<File> l = new ArrayList<File>();
        String[] s = this.settings.getList("jameica.plugin.dir", null);
        if (s != null && s.length > 0) {
            for (int i = 0; i < s.length; ++i) {
                File f = new File(s[i]);
                try {
                    f = f.getCanonicalFile();
                }
                catch (IOException e) {
                    Logger.warn((String)("unable to convert " + f.getAbsolutePath() + " into canonical path"));
                }
                if (f.equals(sysPluginDir) || f.equals(usrPluginDir)) {
                    Logger.info((String)("skipping system/user plugin dir in jameica.plugin.dir[" + i + "]"));
                    found = true;
                    continue;
                }
                if (!f.canRead() || !f.isDirectory()) {
                    Logger.warn((String)(f.getAbsolutePath() + " is no valid plugin dir, skipping"));
                    continue;
                }
                Logger.info((String)("adding plugin dir " + f.getAbsolutePath()));
                l.add(f);
            }
        }
        if (found) {
            String[] newList = new String[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                newList[i] = ((File)l.get(i)).getAbsolutePath();
            }
            this.settings.setAttribute("jameica.plugin.dir", newList);
        }
        this.pluginDirs = l.toArray(new File[l.size()]);
        return this.pluginDirs;
    }

    public File getSystemPluginDir() {
        if (this.systemPluginDir == null) {
            this.systemPluginDir = new File("plugins");
            try {
                this.systemPluginDir = this.systemPluginDir.getCanonicalFile();
            }
            catch (IOException e) {
                Logger.warn((String)("unable to convert " + this.systemPluginDir.getAbsolutePath() + " into canonical path"));
            }
        }
        return this.systemPluginDir;
    }

    public File getUserPluginDir() {
        if (this.userPluginDir == null) {
            this.userPluginDir = new File(this.workDir, "plugins");
            if (!this.userPluginDir.exists()) {
                Logger.info((String)("creating " + this.userPluginDir.getAbsolutePath()));
                this.userPluginDir.mkdirs();
            }
            try {
                this.userPluginDir = this.userPluginDir.getCanonicalFile();
            }
            catch (IOException e) {
                Logger.warn((String)("unable to convert " + this.userPluginDir.getAbsolutePath() + " into canonical path"));
            }
        }
        return this.userPluginDir;
    }

    public File getUpdateDir() {
        if (this.updateDir == null) {
            this.updateDir = new File(this.workDir, "updates");
            if (!this.updateDir.exists()) {
                Logger.info((String)("creating " + this.updateDir.getAbsolutePath()));
                this.updateDir.mkdirs();
            }
            try {
                this.updateDir = this.updateDir.getCanonicalFile();
            }
            catch (IOException e) {
                Logger.warn((String)("unable to convert " + this.updateDir.getAbsolutePath() + " into canonical path"));
            }
        }
        return this.updateDir;
    }

    public String getLogFile() {
        return this.getWorkDir() + File.separator + "jameica.log";
    }

    public long getLogSize() {
        int def = 1;
        int i = this.settings.getInt("jameica.log.size.mb", def);
        if (i < 1 || i > 50) {
            i = def;
        }
        return (long)i * 1024L * 1024L;
    }

    public boolean getMandatoryCheck() {
        return this.settings.getBoolean("jameica.system.checkmandatory", true);
    }

    public void setMandatoryCheck(boolean check) {
        this.settings.setAttribute("jameica.system.checkmandatory", check);
    }

    public boolean getMandatoryLabel() {
        return this.settings.getBoolean("jameica.system.mandatorylabel", false);
    }

    public void setMandatoryLabel(boolean check) {
        this.settings.setAttribute("jameica.system.mandatorylabel", check);
    }

    public String getLogLevel() {
        return this.settings.getString("jameica.system.log.level", Level.DEFAULT.getName());
    }

    public void setLoglevel(String name) {
        this.settings.setAttribute("jameica.system.log.level", name);
        Logger.setLevel((Level)Level.findByName((String)name));
    }

    public synchronized String getConfigDir() {
        if (this.configDir == null) {
            this.configDir = new File(this.getWorkDir(), "cfg");
            if (!this.configDir.exists()) {
                Logger.info((String)("creating " + this.configDir.getAbsolutePath()));
                this.configDir.mkdirs();
            }
        }
        return this.configDir.getAbsolutePath();
    }

    public String getWorkDir() {
        try {
            return this.workDir.getCanonicalPath();
        }
        catch (IOException e) {
            return this.workDir.getAbsolutePath();
        }
    }

    public String getBackupDir() throws ApplicationException {
        String defaultDir = this.getWorkDir();
        String dir = this.settings.getString("jameica.system.backup.dir", null);
        if (dir == null) {
            return defaultDir;
        }
        File f = new File(dir);
        if (f.exists() && f.isDirectory() && f.canWrite()) {
            return f.getAbsolutePath();
        }
        Logger.warn((String)("invalid backup dir " + dir + ", resetting to default: " + defaultDir));
        this.setBackupDir(null);
        return defaultDir;
    }

    public void setBackupDir(String dir) throws ApplicationException {
        File f;
        block6: {
            if (dir == null || dir.length() == 0) {
                this.settings.setAttribute("jameica.system.backup.dir", null);
                return;
            }
            f = new File(dir);
            try {
                if (f.getCanonicalPath().equals(this.workDir.getCanonicalPath())) {
                    this.settings.setAttribute("jameica.system.backup.dir", null);
                    return;
                }
            }
            catch (IOException e) {
                if (!f.equals(this.workDir)) break block6;
                this.settings.setAttribute("jameica.system.backup.dir", null);
                return;
            }
        }
        if (!f.isDirectory() || !f.exists()) {
            throw new ApplicationException(Application.getI18n().tr("Bitte geben Sie ein g\u00fcltiges Verzeichnis an"));
        }
        if (!f.canWrite()) {
            throw new ApplicationException(Application.getI18n().tr("Sie besitzen keine Schreibrechte in diesem Verzeichnis"));
        }
        this.settings.setAttribute("jameica.system.backup.dir", f.getAbsolutePath());
    }

    public int getBackupCount() {
        int count = this.settings.getInt("jameica.system.backup.count", 10);
        if (count < 1) {
            Logger.warn((String)("invalid backup count: " + count + ", resetting to default"));
            this.setBackupCount(-1);
        }
        return count;
    }

    public void setBackupCount(int count) {
        this.settings.setAttribute("jameica.system.backup.count", count < 1 ? 10 : count);
    }

    public boolean getUseBackup() {
        return this.settings.getBoolean("jameica.system.backup.enabled", true);
    }

    public void setUseBackup(boolean enabled) {
        this.settings.setAttribute("jameica.system.backup.enabled", enabled);
    }

    public String getStoreUntranslatedDir() {
        return StringUtils.trimToNull((String)this.settings.getString("jameica.system.i18n.untranslated.dir", null));
    }

    public boolean getMigration(String s) {
        if (s == null || !s.startsWith("migration-")) {
            return false;
        }
        return this.settings.getBoolean(s, false);
    }
}

